<?php
// db.php for database connection
include('db.php');

// Initialize the response array
$response = array();

// Prepare the SQL query to fetch all customer data
$query = "SELECT c.id, c.displayname, c.phoneno, c.customertype,  
                 c.advance, COALESCE(SUM(i.Balance), 0) AS due, 
                 c.utmid, c.type 
          FROM customer c 
          LEFT JOIN invoice i ON c.id = i.user_id 
          WHERE c.delete_status = 0 
          GROUP BY c.id, c.displayname, c.phoneno, c.customertype, 
                   c.advance, c.utmid, c.type";


// Execute the query
$result = $conn->query($query);

// Check if data exists
if ($result->num_rows > 0) {
    // Initialize an array to hold all customers
    $customers = array();

    // Fetch all customer data as associative arrays
    while ($row = $result->fetch_assoc()) {
        $customers[] = array(
            "id" => $row['id'],
            "displayname" => $row['displayname'],
            "phoneno" => $row['phoneno'],
            "customertype" => $row['customertype'],
            "WalletPoints" => 0,
            "advance" => number_format((float)$row['advance'], 2, '.', ''), 
            "due" => number_format((float)$row['due'], 2, '.', ''),
            "utmid" => $row['utmid'],
            "type" => $row['type']
        );
    }

    // Prepare the response
    $response = array("customers" => $customers);
} else {
    // No customers found
    $response = array("message" => "No customers found");
}

// Close the database connection
$conn->close();

// Return the response as JSON
echo json_encode($response);
?>
